Option Explicit
Const scriptName = "Fan Text Selection"
Const scriptVer = "1.0.0"

' Revision History

' 1.0.0 - July 26, 2002 - MJM - Inital version.



' Script properties
Const defStartSlant = -20
Const defEndSlant = 20

' Script constants, questions, and error messages.
Const qStartValue = "Enter starting slant value:"
Const qEndValue = "Enter ending slant value:"

Const errNoSelection = "This script requires a text selection of at least two characters."
Const errNotInRange = "Please enter a number from -60 to 60."
Const errValuesTheSame = "The values must be different."

Const minSlant = -60
Const maxSlant = 60




'Main

Dim errNum
errNum = 0

Dim CreatorApp
Set CreatorApp = WScript.CreateObject("Creator.Application")
'Set CreatorApp = GetObject(,"Creator.Application")

CreatorApp.Visible = True

Dim TextSel
If CreatorApp.Documents.Count = 0 Then
  Call MsgBox(errNoSelection, vbOkonly, scriptName)
  errNum = -1
End If

If errNum = 0 Then
  On Error Resume Next
  Set TextSel = CreatorApp.TextSelection
  errNum = Err.Number
  On Error GoTo 0
  
  If errNum <> 0 Then
    Call MsgBox(errNoSelection, vbOkonly, scriptName)
  Elseif TextSel.CharacterRuns.Count < 1 Then
    Call MsgBox(errNoSelection, vbOkonly, scriptName)
    errNum = -1
  Elseif TextSel.Start > TextSel.End Then
    Call MsgBox(errNoSelection, vbOkonly, scriptName)
    errNum = -1
  Elseif TextSel.Characters.Count < 2 Then
    Call MsgBox(errNoSelection, vbOkonly, scriptName)
    errNum = -1
  End If
End If

Dim answerText, startSlant, endSlant
Dim continueOn
If errNum = 0 Then
  continueOn = False
  startSlant = defStartSlant
  
  Do
    answerText = InputBox(qStartValue, scriptName, startSlant)
    If answerText = "" Then
      continueOn = True
      errNum = -1
    Else
  	On Error Resume Next
      startSlant = CDbl(answerText)
      errNum = Err.Number
      On Error GoTo 0

      If errNum <> 0 Then
        Call MsgBox(errNotInRange, vbOkonly, scriptName)
      Elseif (startSlant < minSlant) Or (startSlant > maxSlant) Then
        Call MsgBox(errNotInRange, vbOkonly, scriptName)
      Else
        continueOn = True
      End If
    End If
  Loop Until continueOn = True
End If

If errNum = 0 Then
  continueOn = False
  endSlant = defEndSlant
  
  If answerText <> "" Then 
    Do
      answerText = InputBox(qEndValue, scriptName, endSlant)

      If answerText = "" Then
        continueOn = True
        errNum = -1
      Else
    	  On Error Resume Next
        endSlant = CDbl(answerText)
        errNum = Err.Number
        On Error GoTo 0
        
        If errNum <> 0 Then
          Call MsgBox(errNotInRange, vbOkonly, scriptName)
        Elseif (endSlant < minSlant) Or (endSlant > maxSlant) Then
          Call MsgBox(errNotInRange, vbOkonly, scriptName)
        'Elseif endValue = startValue
          'Call MsgBox(errValuesTheSame, vbOkonly, scriptName)
        Else
          continueOn = True
        End If
      End If
    Loop Until continueOn = True
  End If
End If

' Whew!  User Interface Section Done.
If errNum = 0 Then
  Dim numChars, incAmount, theOffset
  numChars = TextSel.Characters.Count
  incAmount = (endSlant - startSlant) / (numChars - 1)
  theOffset = startSlant
  TextSel.Italicize = True


  Dim char
  For Each char In TextSel.Characters
    char.ItalicSkew = theOffset
    theOffset = theOffset + incAmount
  Next
End If




